// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/application/public/interfaces/service_provider.mojom
//

package org.chromium.mojom.mojo;

class ServiceProvider_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ServiceProvider, ServiceProvider.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ServiceProvider, ServiceProvider.Proxy>() {
    
        public String getName() {
            return "mojo::ServiceProvider";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ServiceProvider impl) {
            return new Stub(core, impl);
        }
    
        public ServiceProvider[] buildArray(int size) {
          return new ServiceProvider[size];
        }
    };

    private static final int CONNECT_TO_SERVICE_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ServiceProvider.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connectToService(String interfaceName, org.chromium.mojo.system.MessagePipeHandle pipe) {
            ServiceProviderConnectToServiceParams _message = new ServiceProviderConnectToServiceParams();
            _message.interfaceName = interfaceName;
            _message.pipe = pipe;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CONNECT_TO_SERVICE_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ServiceProvider> {

        Stub(org.chromium.mojo.system.Core core, ServiceProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServiceProvider_Internal.MANAGER, messageWithHeader);
                    case CONNECT_TO_SERVICE_ORDINAL: {
                        ServiceProviderConnectToServiceParams data =
                                ServiceProviderConnectToServiceParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connectToService(data.interfaceName, data.pipe);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServiceProvider_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ServiceProviderConnectToServiceParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String interfaceName;
        public org.chromium.mojo.system.MessagePipeHandle pipe;
    
        private ServiceProviderConnectToServiceParams(int version) {
            super(STRUCT_SIZE, version);
            pipe = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public ServiceProviderConnectToServiceParams() {
            this(0);
        }
    
        public static ServiceProviderConnectToServiceParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServiceProviderConnectToServiceParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServiceProviderConnectToServiceParams result = new ServiceProviderConnectToServiceParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.interfaceName = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.pipe = decoder0.readMessagePipeHandle(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(interfaceName, 8, false);
            encoder0.encode(pipe, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServiceProviderConnectToServiceParams other = (ServiceProviderConnectToServiceParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.interfaceName, other.interfaceName))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.pipe, other.pipe))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(interfaceName);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(pipe);
            return result;
        }
    }

}

